<?php

class TestModel extends CFormModel
{
	public $nip;

	public function rules()
	{
		return array(
			array('nip', 'ext.Validators.NipValidator'),
		);
	}
}

class TestModelNatural extends CFormModel
{
	public $nip;

	public function rules()
	{
		return array(
			array('nip', 'ext.Validators.NipValidator', 'pattern' => 'natural'),
		);
	}
}

class TestModelBusiness extends CFormModel
{
	public $nip;

	public function rules()
	{
		return array(
			array('nip', 'ext.Validators.NipValidator', 'pattern' => 'business'),
		);
	}
}

class TestModelNoCk extends CFormModel
{
	public $nip;

	public function rules()
	{
		return array(
			array('nip', 'ext.Validators.NipValidator', 'disableChecksum' => true),
		);
	}
}

class NipValidatorTest extends PHPUnit_Framework_TestCase
{
	/**
	 * @dataProvider dataProviderTestValidateAttribute
	 */
	public function testValidateAttribute($nip, $errors, $class = 'TestModel')
	{
		$model = new $class();
		$model->nip = $nip;
		$this->assertEquals($nip, $model->nip);
		$model->validate();
		$this->assertEquals($model->errors, $errors);
	}

	public function dataProviderTestValidateAttribute()
	{
		static $data = array(
			//bad
			array('qwertyuiop', array('nip'=>array('Pole Nip jest nieprawidłowe.'))),
			array('invalid nip', array('nip'=>array('Pole Nip jest nieprawidłowe.'))),
			array('1234', array('nip'=>array('Pole Nip jest nieprawidłowe.'))),
			array('', array()),
			array(null, array()),
			array(0, array(), 'TestModelNatural'),
			array(false, array(), 'TestModelBusiness'),
			array(123, array('nip'=>array('Pole Nip niespełnia wzorca 999-999-99-99.')), 'TestModelNatural'),
			array(123, array('nip'=>array('Pole Nip niespełnia wzorca 999-99-99-999.')), 'TestModelBusiness'),
			//good string
			array('6771731779', array()),
			array('3554288795', array()),
			array('7963342152', array()),
			array('3554288795', array('nip'=>array('Pole Nip niespełnia wzorca 999-999-99-99.')), 'TestModelNatural'),
			array('7963342152', array('nip'=>array('Pole Nip niespełnia wzorca 999-99-99-999.')), 'TestModelBusiness'),
			//good number
			array(5518012228, array()),
			array(4329667979, array()),
			array(5518012228, array('nip'=>array('Pole Nip niespełnia wzorca 999-999-99-99.')), 'TestModelNatural'),
			array(4329667979, array('nip'=>array('Pole Nip niespełnia wzorca 999-99-99-999.')), 'TestModelBusiness'),
			//bad string
			array('6771731778', array('nip'=>array('Pole Nip ma niepoprawną sumę kontrolną.'))),
			array('3554278795', array('nip'=>array('Pole Nip ma niepoprawną sumę kontrolną.'))),
			array('7962342152', array('nip'=>array('Pole Nip ma niepoprawną sumę kontrolną.'))),
			array('3554278795', array('nip'=>array('Pole Nip niespełnia wzorca 999-999-99-99.')), 'TestModelNatural'),
			array('7962342152', array('nip'=>array('Pole Nip niespełnia wzorca 999-99-99-999.')), 'TestModelBusiness'),
			//bad number
			array(5518012226, array('nip'=>array('Pole Nip ma niepoprawną sumę kontrolną.'))),
			array(4329667379, array('nip'=>array('Pole Nip ma niepoprawną sumę kontrolną.'))),
			array(5518012226, array('nip'=>array('Pole Nip niespełnia wzorca 999-999-99-99.')), 'TestModelNatural'),
			array(4329667379, array('nip'=>array('Pole Nip niespełnia wzorca 999-99-99-999.')), 'TestModelBusiness'),
			array('677-173-17-79', array(), 'TestModelNatural'),
			array('355-428-87-95', array(), 'TestModelNatural'),
			array('796-334-21-52', array(), 'TestModelNatural'),
			array('677-17-31-779', array(), 'TestModelBusiness'),
			array('355-42-88-795', array(), 'TestModelBusiness'),
			array('796-33-42-152', array(), 'TestModelBusiness'),
			//nock
			array('qwertyuiop', array('nip'=>array('Pole Nip jest nieprawidłowe.')), 'TestModelNoCk'),
			array('invalid nip', array('nip'=>array('Pole Nip jest nieprawidłowe.')), 'TestModelNoCk'),
			array('1234', array('nip'=>array('Pole Nip jest nieprawidłowe.')), 'TestModelNoCk'),
			array('6771731778', array(), 'TestModelNoCk'),
			array('3554278795', array(), 'TestModelNoCk'),
			array('7962342152', array(), 'TestModelNoCk'),
		);
		return $data;
	}
}
